/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWGuidPropertyTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWGuidFieldDescriptionPanel
extends JPanel
implements IVWDescriptionPanel {
    private JTextField m_nameTextField = null;
    private JTextField m_arrayTextField = null;
    private VWTable m_parameterTable = null;
    private VWGuidPropertyTableModel m_tableModel = null;
    private JTextArea m_descriptionTextArea = null;
    private VWFieldDefinition m_fieldDefinition = null;
    private VWExpressionItem m_expressionItem = null;

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 2, 0, 2);
        VWToolbarBorder m_nameBorder = new VWToolbarBorder(VWResource.s_name);
        this.add((Component)m_nameBorder, gbCons);
        JPanel namePanel = m_nameBorder.getClientPanel();
        namePanel.setLayout(new GridLayout());
        this.m_nameTextField = new JTextField();
        this.m_nameTextField.setEditable(false);
        namePanel.add(this.m_nameTextField);
        ++gbCons.gridx;
        gbCons.fill = 1;
        gbCons.weighty = 0.2;
        gbCons.gridheight = 2;
        VWToolbarBorder m_descriptionBorder = new VWToolbarBorder(VWResource.s_description);
        this.add((Component)m_descriptionBorder, gbCons);
        JPanel descriptionPanel = m_descriptionBorder.getClientPanel();
        descriptionPanel.setLayout(new GridLayout());
        this.m_descriptionTextArea = new JTextArea();
        this.m_descriptionTextArea.setEditable(false);
        descriptionPanel.add(new JScrollPane(this.m_descriptionTextArea));
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        VWToolbarBorder m_arrayBorder = new VWToolbarBorder(VWResource.s_array);
        this.add((Component)m_arrayBorder, gbCons);
        JPanel arrayPanel = m_arrayBorder.getClientPanel();
        arrayPanel.setLayout(new GridLayout());
        this.m_arrayTextField = new JTextField();
        this.m_arrayTextField.setEditable(false);
        arrayPanel.add(this.m_arrayTextField);
        gbCons.fill = 1;
        ++gbCons.gridy;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridwidth = 2;
        VWToolbarBorder propertyBorder = new VWToolbarBorder(VWResource.s_properties);
        this.add((Component)propertyBorder, gbCons);
        JPanel propertyPanel = propertyBorder.getClientPanel();
        propertyPanel.setLayout(new GridLayout());
        this.m_tableModel = new VWGuidPropertyTableModel();
        this.m_parameterTable = new VWTable(this.m_tableModel);
        this.m_parameterTable.setSelectionMode(0);
        propertyPanel.add(new JScrollPane(this.m_parameterTable));
    }

    public String getExpressionItem() {
        String expressionItem = null;
        try {
            if (this.m_expressionItem != null) {
                expressionItem = this.m_expressionItem.toString();
                int nSelectedRow = this.m_parameterTable.getSelectedRow();
                if (nSelectedRow != -1) {
                    expressionItem = expressionItem + "." + this.m_tableModel.getValueAt(nSelectedRow, 0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return expressionItem;
    }

    public void setExpressionItem(VWExpressionItem item) {
        Object expressionItem;
        this.m_expressionItem = item;
        this.m_fieldDefinition = null;
        if (item != null && (expressionItem = item.getExpressionItem()) instanceof VWFieldDefinition) {
            this.m_fieldDefinition = (VWFieldDefinition)expressionItem;
        }
        this.reinitialize();
    }

    private void reinitialize() {
        try {
            if (this.m_fieldDefinition != null) {
                this.m_nameTextField.setText(this.m_fieldDefinition.getName());
                this.m_arrayTextField.setText(this.m_fieldDefinition.isArray() ? VWResource.s_yes : VWResource.s_no);
                this.m_descriptionTextArea.setText(this.m_fieldDefinition.getDescription());
                this.m_tableModel.reinitialize(this.m_fieldDefinition.getCEObjectInfo());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

